/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.w3c.dom.Node;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpBaseVariable;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpContainerValue;

public class DBGpContainerVariable
extends DBGpBaseVariable
implements IVariable {
    private int page;
    private int pageSize;
    private int numChildren;
    private DBGpContainerValue value;

    public DBGpContainerVariable(IDebugTarget target, int page, int pageSize, int numChildren, Node property, String stackLevel, String fullName) {
        super(target, stackLevel, fullName);
        this.page = page;
        this.pageSize = pageSize;
        this.numChildren = numChildren;
        this.value = property != null ? new DBGpContainerValue(this, property) : new DBGpContainerValue(this, null);
    }

    public String getName() throws DebugException {
        int startIndex = this.page * this.pageSize;
        int endIndex = (this.page + 1) * this.pageSize - 1;
        if (endIndex > this.numChildren) {
            endIndex = this.numChildren - 1;
        }
        return "[" + startIndex + "..." + endIndex + "]";
    }

    public String getReferenceTypeName() throws DebugException {
        return "Container";
    }

    public IValue getValue() throws DebugException {
        return this.value;
    }

    public int getPage() {
        return this.page;
    }

    public int getPageSize() {
        return this.pageSize;
    }
}

